/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.DeviceCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IDeviceCollectionWithReferencesRequest;
import java.util.List;

public class DeviceCollectionWithReferencesRequest
extends BaseCollectionRequest<DeviceCollectionResponse, IDeviceCollectionPage>
implements IDeviceCollectionWithReferencesRequest {
    public DeviceCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceCollectionResponse.class, IDeviceCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IDeviceCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DeviceCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceCollectionWithReferencesPage get() throws ClientException {
        DeviceCollectionResponse response = (DeviceCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IDeviceCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IDeviceCollectionWithReferencesRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IDeviceCollectionWithReferencesRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IDeviceCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IDeviceCollectionWithReferencesPage buildFromResponse(DeviceCollectionResponse response) {
        DeviceCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new DeviceCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceCollectionWithReferencesPage page = new DeviceCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

