/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Fido2AuthenticationMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.Fido2AuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.extensions.Fido2AuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.Fido2AuthenticationMethodCollectionResponse;
import com.microsoft.graph.requests.extensions.Fido2AuthenticationMethodRequestBuilder;
import com.microsoft.graph.requests.extensions.IFido2AuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.extensions.IFido2AuthenticationMethodCollectionRequest;
import java.util.List;

public class Fido2AuthenticationMethodCollectionRequest
extends BaseCollectionRequest<Fido2AuthenticationMethodCollectionResponse, IFido2AuthenticationMethodCollectionPage>
implements IFido2AuthenticationMethodCollectionRequest {
    public Fido2AuthenticationMethodCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Fido2AuthenticationMethodCollectionResponse.class, IFido2AuthenticationMethodCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IFido2AuthenticationMethodCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(Fido2AuthenticationMethodCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IFido2AuthenticationMethodCollectionPage get() throws ClientException {
        Fido2AuthenticationMethodCollectionResponse response = (Fido2AuthenticationMethodCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Fido2AuthenticationMethod newFido2AuthenticationMethod, ICallback<? super Fido2AuthenticationMethod> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new Fido2AuthenticationMethodRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newFido2AuthenticationMethod, callback);
    }

    @Override
    public Fido2AuthenticationMethod post(Fido2AuthenticationMethod newFido2AuthenticationMethod) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new Fido2AuthenticationMethodRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newFido2AuthenticationMethod);
    }

    @Override
    public IFido2AuthenticationMethodCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IFido2AuthenticationMethodCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IFido2AuthenticationMethodCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IFido2AuthenticationMethodCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IFido2AuthenticationMethodCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IFido2AuthenticationMethodCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IFido2AuthenticationMethodCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IFido2AuthenticationMethodCollectionPage buildFromResponse(Fido2AuthenticationMethodCollectionResponse response) {
        Fido2AuthenticationMethodCollectionRequestBuilder builder = response.nextLink != null ? new Fido2AuthenticationMethodCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        Fido2AuthenticationMethodCollectionPage page = new Fido2AuthenticationMethodCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

