/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.MicrosoftAuthenticatorAuthenticationMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMicrosoftAuthenticatorAuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.extensions.IMicrosoftAuthenticatorAuthenticationMethodCollectionRequest;
import com.microsoft.graph.requests.extensions.MicrosoftAuthenticatorAuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.extensions.MicrosoftAuthenticatorAuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MicrosoftAuthenticatorAuthenticationMethodCollectionResponse;
import com.microsoft.graph.requests.extensions.MicrosoftAuthenticatorAuthenticationMethodRequestBuilder;
import java.util.List;

public class MicrosoftAuthenticatorAuthenticationMethodCollectionRequest
extends BaseCollectionRequest<MicrosoftAuthenticatorAuthenticationMethodCollectionResponse, IMicrosoftAuthenticatorAuthenticationMethodCollectionPage>
implements IMicrosoftAuthenticatorAuthenticationMethodCollectionRequest {
    public MicrosoftAuthenticatorAuthenticationMethodCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MicrosoftAuthenticatorAuthenticationMethodCollectionResponse.class, IMicrosoftAuthenticatorAuthenticationMethodCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IMicrosoftAuthenticatorAuthenticationMethodCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(MicrosoftAuthenticatorAuthenticationMethodCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMicrosoftAuthenticatorAuthenticationMethodCollectionPage get() throws ClientException {
        MicrosoftAuthenticatorAuthenticationMethodCollectionResponse response = (MicrosoftAuthenticatorAuthenticationMethodCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MicrosoftAuthenticatorAuthenticationMethod newMicrosoftAuthenticatorAuthenticationMethod, ICallback<? super MicrosoftAuthenticatorAuthenticationMethod> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MicrosoftAuthenticatorAuthenticationMethodRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMicrosoftAuthenticatorAuthenticationMethod, callback);
    }

    @Override
    public MicrosoftAuthenticatorAuthenticationMethod post(MicrosoftAuthenticatorAuthenticationMethod newMicrosoftAuthenticatorAuthenticationMethod) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MicrosoftAuthenticatorAuthenticationMethodRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMicrosoftAuthenticatorAuthenticationMethod);
    }

    @Override
    public IMicrosoftAuthenticatorAuthenticationMethodCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IMicrosoftAuthenticatorAuthenticationMethodCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IMicrosoftAuthenticatorAuthenticationMethodCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IMicrosoftAuthenticatorAuthenticationMethodCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMicrosoftAuthenticatorAuthenticationMethodCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IMicrosoftAuthenticatorAuthenticationMethodCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IMicrosoftAuthenticatorAuthenticationMethodCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IMicrosoftAuthenticatorAuthenticationMethodCollectionPage buildFromResponse(MicrosoftAuthenticatorAuthenticationMethodCollectionResponse response) {
        MicrosoftAuthenticatorAuthenticationMethodCollectionRequestBuilder builder = response.nextLink != null ? new MicrosoftAuthenticatorAuthenticationMethodCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MicrosoftAuthenticatorAuthenticationMethodCollectionPage page = new MicrosoftAuthenticatorAuthenticationMethodCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

