/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Planner;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPlannerRequest;
import java.util.List;

public class PlannerRequest
extends BaseRequest
implements IPlannerRequest {
    public PlannerRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Planner.class);
    }

    @Override
    public void get(ICallback<? super Planner> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Planner get() throws ClientException {
        return (Planner)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Planner> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Planner sourcePlanner, ICallback<? super Planner> callback) {
        this.send(HttpMethod.PATCH, callback, sourcePlanner);
    }

    @Override
    public Planner patch(Planner sourcePlanner) throws ClientException {
        return (Planner)this.send(HttpMethod.PATCH, sourcePlanner);
    }

    @Override
    public void post(Planner newPlanner, ICallback<? super Planner> callback) {
        this.send(HttpMethod.POST, callback, newPlanner);
    }

    @Override
    public Planner post(Planner newPlanner) throws ClientException {
        return (Planner)this.send(HttpMethod.POST, newPlanner);
    }

    @Override
    public void put(Planner newPlanner, ICallback<? super Planner> callback) {
        this.send(HttpMethod.PUT, callback, newPlanner);
    }

    @Override
    public Planner put(Planner newPlanner) throws ClientException {
        return (Planner)this.send(HttpMethod.PUT, newPlanner);
    }

    @Override
    public IPlannerRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPlannerRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

