/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.SignIn;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISignInCollectionPage;
import com.microsoft.graph.requests.extensions.ISignInCollectionRequest;
import com.microsoft.graph.requests.extensions.SignInCollectionPage;
import com.microsoft.graph.requests.extensions.SignInCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SignInCollectionResponse;
import com.microsoft.graph.requests.extensions.SignInRequestBuilder;
import java.util.List;

public class SignInCollectionRequest
extends BaseCollectionRequest<SignInCollectionResponse, ISignInCollectionPage>
implements ISignInCollectionRequest {
    public SignInCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SignInCollectionResponse.class, ISignInCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ISignInCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SignInCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISignInCollectionPage get() throws ClientException {
        SignInCollectionResponse response = (SignInCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SignIn newSignIn, ICallback<? super SignIn> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SignInRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSignIn, callback);
    }

    @Override
    public SignIn post(SignIn newSignIn) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SignInRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSignIn);
    }

    @Override
    public ISignInCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISignInCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ISignInCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public ISignInCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISignInCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ISignInCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ISignInCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ISignInCollectionPage buildFromResponse(SignInCollectionResponse response) {
        SignInCollectionRequestBuilder builder = response.nextLink != null ? new SignInCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SignInCollectionPage page = new SignInCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

