/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TimeOff;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITimeOffCollectionPage;
import com.microsoft.graph.requests.extensions.ITimeOffCollectionRequest;
import com.microsoft.graph.requests.extensions.TimeOffCollectionPage;
import com.microsoft.graph.requests.extensions.TimeOffCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TimeOffCollectionResponse;
import com.microsoft.graph.requests.extensions.TimeOffRequestBuilder;
import java.util.List;

public class TimeOffCollectionRequest
extends BaseCollectionRequest<TimeOffCollectionResponse, ITimeOffCollectionPage>
implements ITimeOffCollectionRequest {
    public TimeOffCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TimeOffCollectionResponse.class, ITimeOffCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ITimeOffCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TimeOffCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITimeOffCollectionPage get() throws ClientException {
        TimeOffCollectionResponse response = (TimeOffCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TimeOff newTimeOff, ICallback<? super TimeOff> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TimeOffRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTimeOff, callback);
    }

    @Override
    public TimeOff post(TimeOff newTimeOff) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TimeOffRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTimeOff);
    }

    @Override
    public ITimeOffCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ITimeOffCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ITimeOffCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public ITimeOffCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITimeOffCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ITimeOffCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ITimeOffCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ITimeOffCollectionPage buildFromResponse(TimeOffCollectionResponse response) {
        TimeOffCollectionRequestBuilder builder = response.nextLink != null ? new TimeOffCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TimeOffCollectionPage page = new TimeOffCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

