/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TimeOffReason;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITimeOffReasonCollectionPage;
import com.microsoft.graph.requests.extensions.ITimeOffReasonCollectionRequest;
import com.microsoft.graph.requests.extensions.TimeOffReasonCollectionPage;
import com.microsoft.graph.requests.extensions.TimeOffReasonCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TimeOffReasonCollectionResponse;
import com.microsoft.graph.requests.extensions.TimeOffReasonRequestBuilder;
import java.util.List;

public class TimeOffReasonCollectionRequest
extends BaseCollectionRequest<TimeOffReasonCollectionResponse, ITimeOffReasonCollectionPage>
implements ITimeOffReasonCollectionRequest {
    public TimeOffReasonCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TimeOffReasonCollectionResponse.class, ITimeOffReasonCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ITimeOffReasonCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TimeOffReasonCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITimeOffReasonCollectionPage get() throws ClientException {
        TimeOffReasonCollectionResponse response = (TimeOffReasonCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TimeOffReason newTimeOffReason, ICallback<? super TimeOffReason> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TimeOffReasonRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTimeOffReason, callback);
    }

    @Override
    public TimeOffReason post(TimeOffReason newTimeOffReason) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TimeOffReasonRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTimeOffReason);
    }

    @Override
    public ITimeOffReasonCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ITimeOffReasonCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ITimeOffReasonCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public ITimeOffReasonCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITimeOffReasonCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ITimeOffReasonCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ITimeOffReasonCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ITimeOffReasonCollectionPage buildFromResponse(TimeOffReasonCollectionResponse response) {
        TimeOffReasonCollectionRequestBuilder builder = response.nextLink != null ? new TimeOffReasonCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TimeOffReasonCollectionPage page = new TimeOffReasonCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

