/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Alert;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.AlertCollectionPage;
import com.microsoft.graph.requests.AlertCollectionRequestBuilder;
import com.microsoft.graph.requests.AlertCollectionResponse;
import com.microsoft.graph.requests.AlertRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AlertCollectionRequest
extends BaseEntityCollectionRequest<Alert, AlertCollectionResponse, AlertCollectionPage> {
    public AlertCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AlertCollectionResponse.class, AlertCollectionPage.class, AlertCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Alert> postAsync(@Nonnull Alert newAlert) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AlertRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newAlert);
    }

    @Nonnull
    public Alert post(@Nonnull Alert newAlert) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AlertRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAlert);
    }

    @Nonnull
    public AlertCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public AlertCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public AlertCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public AlertCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public AlertCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public AlertCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public AlertCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public AlertCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public AlertCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

