/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.Channel;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChannelRequest
extends BaseRequest<Channel> {
    public ChannelRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Channel.class);
    }

    @Nonnull
    public CompletableFuture<Channel> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Channel get() throws ClientException {
        return (Channel)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Channel> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Channel delete() throws ClientException {
        return (Channel)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Channel> patchAsync(@Nonnull Channel sourceChannel) {
        return this.sendAsync(HttpMethod.PATCH, sourceChannel);
    }

    @Nullable
    public Channel patch(@Nonnull Channel sourceChannel) throws ClientException {
        return (Channel)this.send(HttpMethod.PATCH, sourceChannel);
    }

    @Nonnull
    public CompletableFuture<Channel> postAsync(@Nonnull Channel newChannel) {
        return this.sendAsync(HttpMethod.POST, newChannel);
    }

    @Nullable
    public Channel post(@Nonnull Channel newChannel) throws ClientException {
        return (Channel)this.send(HttpMethod.POST, newChannel);
    }

    @Nonnull
    public CompletableFuture<Channel> putAsync(@Nonnull Channel newChannel) {
        return this.sendAsync(HttpMethod.PUT, newChannel);
    }

    @Nullable
    public Channel put(@Nonnull Channel newChannel) throws ClientException {
        return (Channel)this.send(HttpMethod.PUT, newChannel);
    }

    @Nonnull
    public ChannelRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ChannelRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

