// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Audio Conferencing.
 */
public class AudioConferencing implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Conference Id.
     * The conference id of the online meeting.
     */
    @SerializedName(value = "conferenceId", alternate = {"ConferenceId"})
    @Expose
	@Nullable
    public String conferenceId;

    /**
     * The Dialin Url.
     * A URL to the externally-accessible web page that contains dial-in information.
     */
    @SerializedName(value = "dialinUrl", alternate = {"DialinUrl"})
    @Expose
	@Nullable
    public String dialinUrl;

    /**
     * The Toll Free Number.
     * 
     */
    @SerializedName(value = "tollFreeNumber", alternate = {"TollFreeNumber"})
    @Expose
	@Nullable
    public String tollFreeNumber;

    /**
     * The Toll Free Numbers.
     * List of toll-free numbers that are displayed in the meeting invite.
     */
    @SerializedName(value = "tollFreeNumbers", alternate = {"TollFreeNumbers"})
    @Expose
	@Nullable
    public java.util.List<String> tollFreeNumbers;

    /**
     * The Toll Number.
     * 
     */
    @SerializedName(value = "tollNumber", alternate = {"TollNumber"})
    @Expose
	@Nullable
    public String tollNumber;

    /**
     * The Toll Numbers.
     * List of toll numbers that are displayed in the meeting invite.
     */
    @SerializedName(value = "tollNumbers", alternate = {"TollNumbers"})
    @Expose
	@Nullable
    public java.util.List<String> tollNumbers;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
