// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.UnifiedRoleEligibilityScheduleInstance;
import com.microsoft.graph.models.UnifiedRoleScheduleInstanceBase;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Assignment Schedule Instance.
 */
public class UnifiedRoleAssignmentScheduleInstance extends UnifiedRoleScheduleInstanceBase implements IJsonBackedObject {


    /**
     * The Assignment Type.
     * Type of the assignment. It can either be Assigned or Activated.
     */
    @SerializedName(value = "assignmentType", alternate = {"AssignmentType"})
    @Expose
	@Nullable
    public String assignmentType;

    /**
     * The End Date Time.
     * Time that the roleAssignmentInstance will expire
     */
    @SerializedName(value = "endDateTime", alternate = {"EndDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime endDateTime;

    /**
     * The Member Type.
     * Membership type of the assignment. It can either be Inherited, Direct, or Group.
     */
    @SerializedName(value = "memberType", alternate = {"MemberType"})
    @Expose
	@Nullable
    public String memberType;

    /**
     * The Role Assignment Origin Id.
     * ID of the roleAssignment in the directory
     */
    @SerializedName(value = "roleAssignmentOriginId", alternate = {"RoleAssignmentOriginId"})
    @Expose
	@Nullable
    public String roleAssignmentOriginId;

    /**
     * The Role Assignment Schedule Id.
     * ID of the parent roleAssignmentSchedule for this instance
     */
    @SerializedName(value = "roleAssignmentScheduleId", alternate = {"RoleAssignmentScheduleId"})
    @Expose
	@Nullable
    public String roleAssignmentScheduleId;

    /**
     * The Start Date Time.
     * Time that the roleAssignmentInstance will start
     */
    @SerializedName(value = "startDateTime", alternate = {"StartDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime startDateTime;

    /**
     * The Activated Using.
     * If the roleAssignmentScheduleInstance is activated by a roleEligibilityScheduleRequest, this is the link to the related schedule instance.
     */
    @SerializedName(value = "activatedUsing", alternate = {"ActivatedUsing"})
    @Expose
	@Nullable
    public UnifiedRoleEligibilityScheduleInstance activatedUsing;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
