// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions If Parameter Set.
 */
public class WorkbookFunctionsIfParameterSet {
    /**
     * The logical Test.
     * 
     */
    @SerializedName(value = "logicalTest", alternate = {"LogicalTest"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement logicalTest;

    /**
     * The value If True.
     * 
     */
    @SerializedName(value = "valueIfTrue", alternate = {"ValueIfTrue"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement valueIfTrue;

    /**
     * The value If False.
     * 
     */
    @SerializedName(value = "valueIfFalse", alternate = {"ValueIfFalse"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement valueIfFalse;


    /**
     * Instiaciates a new WorkbookFunctionsIfParameterSet
     */
    public WorkbookFunctionsIfParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsIfParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsIfParameterSet(@Nonnull final WorkbookFunctionsIfParameterSetBuilder builder) {
        this.logicalTest = builder.logicalTest;
        this.valueIfTrue = builder.valueIfTrue;
        this.valueIfFalse = builder.valueIfFalse;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsIfParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsIfParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsIfParameterSet
     */
    public static final class WorkbookFunctionsIfParameterSetBuilder {
        /**
         * The logicalTest parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement logicalTest;
        /**
         * Sets the LogicalTest
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsIfParameterSetBuilder withLogicalTest(@Nullable final com.google.gson.JsonElement val) {
            this.logicalTest = val;
            return this;
        }
        /**
         * The valueIfTrue parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement valueIfTrue;
        /**
         * Sets the ValueIfTrue
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsIfParameterSetBuilder withValueIfTrue(@Nullable final com.google.gson.JsonElement val) {
            this.valueIfTrue = val;
            return this;
        }
        /**
         * The valueIfFalse parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement valueIfFalse;
        /**
         * Sets the ValueIfFalse
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsIfParameterSetBuilder withValueIfFalse(@Nullable final com.google.gson.JsonElement val) {
            this.valueIfFalse = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsIfParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsIfParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsIfParameterSet build() {
            return new WorkbookFunctionsIfParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.logicalTest != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("logicalTest", logicalTest));
        }
        if(this.valueIfTrue != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("valueIfTrue", valueIfTrue));
        }
        if(this.valueIfFalse != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("valueIfFalse", valueIfFalse));
        }
        return result;
    }
}
