// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Xirr Parameter Set.
 */
public class WorkbookFunctionsXirrParameterSet {
    /**
     * The values.
     * 
     */
    @SerializedName(value = "values", alternate = {"Values"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement values;

    /**
     * The dates.
     * 
     */
    @SerializedName(value = "dates", alternate = {"Dates"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement dates;

    /**
     * The guess.
     * 
     */
    @SerializedName(value = "guess", alternate = {"Guess"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement guess;


    /**
     * Instiaciates a new WorkbookFunctionsXirrParameterSet
     */
    public WorkbookFunctionsXirrParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsXirrParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsXirrParameterSet(@Nonnull final WorkbookFunctionsXirrParameterSetBuilder builder) {
        this.values = builder.values;
        this.dates = builder.dates;
        this.guess = builder.guess;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsXirrParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsXirrParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsXirrParameterSet
     */
    public static final class WorkbookFunctionsXirrParameterSetBuilder {
        /**
         * The values parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement values;
        /**
         * Sets the Values
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsXirrParameterSetBuilder withValues(@Nullable final com.google.gson.JsonElement val) {
            this.values = val;
            return this;
        }
        /**
         * The dates parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement dates;
        /**
         * Sets the Dates
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsXirrParameterSetBuilder withDates(@Nullable final com.google.gson.JsonElement val) {
            this.dates = val;
            return this;
        }
        /**
         * The guess parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement guess;
        /**
         * Sets the Guess
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsXirrParameterSetBuilder withGuess(@Nullable final com.google.gson.JsonElement val) {
            this.guess = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsXirrParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsXirrParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsXirrParameterSet build() {
            return new WorkbookFunctionsXirrParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.values != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("values", values));
        }
        if(this.dates != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("dates", dates));
        }
        if(this.guess != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("guess", guess));
        }
        return result;
    }
}
