// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.List;
import com.microsoft.graph.models.ContentType;
import com.microsoft.graph.models.ItemReference;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.ContentTypeCollectionRequestBuilder;
import com.microsoft.graph.requests.ContentTypeRequestBuilder;
import com.microsoft.graph.requests.ContentTypeCollectionRequest;
import com.microsoft.graph.requests.ContentTypeAddCopyRequestBuilder;
import com.microsoft.graph.requests.ContentTypeAddCopyFromContentTypeHubRequestBuilder;
import com.microsoft.graph.requests.ContentTypeGetCompatibleHubContentTypesCollectionRequestBuilder;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.PrimitiveRequestBuilder;
import com.microsoft.graph.models.ContentTypeAddCopyParameterSet;
import com.microsoft.graph.models.ContentTypeAddCopyFromContentTypeHubParameterSet;
import com.microsoft.graph.models.ContentTypeAssociateWithHubSitesParameterSet;
import com.microsoft.graph.models.ContentTypeCopyToDefaultContentLocationParameterSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Content Type Collection Request Builder.
 */
public class ContentTypeCollectionRequestBuilder extends BaseCollectionRequestBuilder<ContentType, ContentTypeRequestBuilder, ContentTypeCollectionResponse, ContentTypeCollectionPage, ContentTypeCollectionRequest> {

    /**
     * The request builder for this collection of List
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ContentTypeCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ContentTypeRequestBuilder.class, ContentTypeCollectionRequest.class);
    }



    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public ContentTypeAddCopyRequestBuilder addCopy(@Nonnull final ContentTypeAddCopyParameterSet parameters) {
        return new ContentTypeAddCopyRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.addCopy"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public ContentTypeAddCopyFromContentTypeHubRequestBuilder addCopyFromContentTypeHub(@Nonnull final ContentTypeAddCopyFromContentTypeHubParameterSet parameters) {
        return new ContentTypeAddCopyFromContentTypeHubRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.addCopyFromContentTypeHub"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder collection
     */
    @Nonnull
    public ContentTypeGetCompatibleHubContentTypesCollectionRequestBuilder getCompatibleHubContentTypes() {
        return new ContentTypeGetCompatibleHubContentTypesCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getCompatibleHubContentTypes"), getClient(), null);
    }

    /**
     * Gets the raw count request for the collection
     * @return The raw count request for the collection
     */
    @Nonnull
    public PrimitiveRequestBuilder<Long> count() {
        return new PrimitiveRequestBuilder<Long>(getRequestUrlWithAdditionalSegment("$count"), getClient(), null, Long.class);
    }
}
