// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeviceManagementExchangeConnector;
import com.microsoft.graph.models.DeviceManagementExchangeConnectorSyncType;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Management Exchange Connector Request.
 */
public class DeviceManagementExchangeConnectorRequest extends BaseRequest<DeviceManagementExchangeConnector> {
	
    /**
     * The request for the DeviceManagementExchangeConnector
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceManagementExchangeConnectorRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceManagementExchangeConnector.class);
    }

    /**
     * Gets the DeviceManagementExchangeConnector from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementExchangeConnector> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DeviceManagementExchangeConnector from the service
     *
     * @return the DeviceManagementExchangeConnector from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceManagementExchangeConnector get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementExchangeConnector> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DeviceManagementExchangeConnector delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DeviceManagementExchangeConnector with a source
     *
     * @param sourceDeviceManagementExchangeConnector the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementExchangeConnector> patchAsync(@Nonnull final DeviceManagementExchangeConnector sourceDeviceManagementExchangeConnector) {
        return sendAsync(HttpMethod.PATCH, sourceDeviceManagementExchangeConnector);
    }

    /**
     * Patches this DeviceManagementExchangeConnector with a source
     *
     * @param sourceDeviceManagementExchangeConnector the source object with updates
     * @return the updated DeviceManagementExchangeConnector
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceManagementExchangeConnector patch(@Nonnull final DeviceManagementExchangeConnector sourceDeviceManagementExchangeConnector) throws ClientException {
        return send(HttpMethod.PATCH, sourceDeviceManagementExchangeConnector);
    }

    /**
     * Creates a DeviceManagementExchangeConnector with a new object
     *
     * @param newDeviceManagementExchangeConnector the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementExchangeConnector> postAsync(@Nonnull final DeviceManagementExchangeConnector newDeviceManagementExchangeConnector) {
        return sendAsync(HttpMethod.POST, newDeviceManagementExchangeConnector);
    }

    /**
     * Creates a DeviceManagementExchangeConnector with a new object
     *
     * @param newDeviceManagementExchangeConnector the new object to create
     * @return the created DeviceManagementExchangeConnector
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceManagementExchangeConnector post(@Nonnull final DeviceManagementExchangeConnector newDeviceManagementExchangeConnector) throws ClientException {
        return send(HttpMethod.POST, newDeviceManagementExchangeConnector);
    }

    /**
     * Creates a DeviceManagementExchangeConnector with a new object
     *
     * @param newDeviceManagementExchangeConnector the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementExchangeConnector> putAsync(@Nonnull final DeviceManagementExchangeConnector newDeviceManagementExchangeConnector) {
        return sendAsync(HttpMethod.PUT, newDeviceManagementExchangeConnector);
    }

    /**
     * Creates a DeviceManagementExchangeConnector with a new object
     *
     * @param newDeviceManagementExchangeConnector the object to create/update
     * @return the created DeviceManagementExchangeConnector
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceManagementExchangeConnector put(@Nonnull final DeviceManagementExchangeConnector newDeviceManagementExchangeConnector) throws ClientException {
        return send(HttpMethod.PUT, newDeviceManagementExchangeConnector);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DeviceManagementExchangeConnectorRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DeviceManagementExchangeConnectorRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

