// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.IosCompliancePolicy;
import com.microsoft.graph.models.DeviceCompliancePolicyAssignment;
import com.microsoft.graph.models.DeviceComplianceScheduledActionForRule;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ios Compliance Policy Request.
 */
public class IosCompliancePolicyRequest extends BaseRequest<IosCompliancePolicy> {
	
    /**
     * The request for the IosCompliancePolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IosCompliancePolicyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, IosCompliancePolicy.class);
    }

    /**
     * Gets the IosCompliancePolicy from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosCompliancePolicy> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the IosCompliancePolicy from the service
     *
     * @return the IosCompliancePolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosCompliancePolicy get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosCompliancePolicy> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public IosCompliancePolicy delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this IosCompliancePolicy with a source
     *
     * @param sourceIosCompliancePolicy the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosCompliancePolicy> patchAsync(@Nonnull final IosCompliancePolicy sourceIosCompliancePolicy) {
        return sendAsync(HttpMethod.PATCH, sourceIosCompliancePolicy);
    }

    /**
     * Patches this IosCompliancePolicy with a source
     *
     * @param sourceIosCompliancePolicy the source object with updates
     * @return the updated IosCompliancePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosCompliancePolicy patch(@Nonnull final IosCompliancePolicy sourceIosCompliancePolicy) throws ClientException {
        return send(HttpMethod.PATCH, sourceIosCompliancePolicy);
    }

    /**
     * Creates a IosCompliancePolicy with a new object
     *
     * @param newIosCompliancePolicy the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosCompliancePolicy> postAsync(@Nonnull final IosCompliancePolicy newIosCompliancePolicy) {
        return sendAsync(HttpMethod.POST, newIosCompliancePolicy);
    }

    /**
     * Creates a IosCompliancePolicy with a new object
     *
     * @param newIosCompliancePolicy the new object to create
     * @return the created IosCompliancePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosCompliancePolicy post(@Nonnull final IosCompliancePolicy newIosCompliancePolicy) throws ClientException {
        return send(HttpMethod.POST, newIosCompliancePolicy);
    }

    /**
     * Creates a IosCompliancePolicy with a new object
     *
     * @param newIosCompliancePolicy the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosCompliancePolicy> putAsync(@Nonnull final IosCompliancePolicy newIosCompliancePolicy) {
        return sendAsync(HttpMethod.PUT, newIosCompliancePolicy);
    }

    /**
     * Creates a IosCompliancePolicy with a new object
     *
     * @param newIosCompliancePolicy the object to create/update
     * @return the created IosCompliancePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosCompliancePolicy put(@Nonnull final IosCompliancePolicy newIosCompliancePolicy) throws ClientException {
        return send(HttpMethod.PUT, newIosCompliancePolicy);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public IosCompliancePolicyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public IosCompliancePolicyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

