// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MeetingAttendanceReport;
import com.microsoft.graph.requests.AttendanceRecordCollectionRequestBuilder;
import com.microsoft.graph.requests.AttendanceRecordRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Meeting Attendance Report Request.
 */
public class MeetingAttendanceReportRequest extends BaseRequest<MeetingAttendanceReport> {
	
    /**
     * The request for the MeetingAttendanceReport
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MeetingAttendanceReportRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MeetingAttendanceReport.class);
    }

    /**
     * Gets the MeetingAttendanceReport from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MeetingAttendanceReport> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the MeetingAttendanceReport from the service
     *
     * @return the MeetingAttendanceReport from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MeetingAttendanceReport get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MeetingAttendanceReport> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public MeetingAttendanceReport delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MeetingAttendanceReport with a source
     *
     * @param sourceMeetingAttendanceReport the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MeetingAttendanceReport> patchAsync(@Nonnull final MeetingAttendanceReport sourceMeetingAttendanceReport) {
        return sendAsync(HttpMethod.PATCH, sourceMeetingAttendanceReport);
    }

    /**
     * Patches this MeetingAttendanceReport with a source
     *
     * @param sourceMeetingAttendanceReport the source object with updates
     * @return the updated MeetingAttendanceReport
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MeetingAttendanceReport patch(@Nonnull final MeetingAttendanceReport sourceMeetingAttendanceReport) throws ClientException {
        return send(HttpMethod.PATCH, sourceMeetingAttendanceReport);
    }

    /**
     * Creates a MeetingAttendanceReport with a new object
     *
     * @param newMeetingAttendanceReport the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MeetingAttendanceReport> postAsync(@Nonnull final MeetingAttendanceReport newMeetingAttendanceReport) {
        return sendAsync(HttpMethod.POST, newMeetingAttendanceReport);
    }

    /**
     * Creates a MeetingAttendanceReport with a new object
     *
     * @param newMeetingAttendanceReport the new object to create
     * @return the created MeetingAttendanceReport
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MeetingAttendanceReport post(@Nonnull final MeetingAttendanceReport newMeetingAttendanceReport) throws ClientException {
        return send(HttpMethod.POST, newMeetingAttendanceReport);
    }

    /**
     * Creates a MeetingAttendanceReport with a new object
     *
     * @param newMeetingAttendanceReport the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MeetingAttendanceReport> putAsync(@Nonnull final MeetingAttendanceReport newMeetingAttendanceReport) {
        return sendAsync(HttpMethod.PUT, newMeetingAttendanceReport);
    }

    /**
     * Creates a MeetingAttendanceReport with a new object
     *
     * @param newMeetingAttendanceReport the object to create/update
     * @return the created MeetingAttendanceReport
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MeetingAttendanceReport put(@Nonnull final MeetingAttendanceReport newMeetingAttendanceReport) throws ClientException {
        return send(HttpMethod.PUT, newMeetingAttendanceReport);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public MeetingAttendanceReportRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public MeetingAttendanceReportRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

