// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrinterBase;
import com.microsoft.graph.models.PrintJob;
import com.microsoft.graph.models.PrintJobConfiguration;
import com.microsoft.graph.models.PrintJobStatus;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.PrintJobCollectionRequestBuilder;
import com.microsoft.graph.requests.PrintJobRequestBuilder;
import com.microsoft.graph.requests.PrintJobCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.PrimitiveRequestBuilder;
import com.microsoft.graph.models.PrintJobAbortParameterSet;
import com.microsoft.graph.models.PrintJobRedirectParameterSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Job Collection Request Builder.
 */
public class PrintJobCollectionRequestBuilder extends BaseCollectionRequestBuilder<PrintJob, PrintJobRequestBuilder, PrintJobCollectionResponse, PrintJobCollectionPage, PrintJobCollectionRequest> {

    /**
     * The request builder for this collection of PrinterBase
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintJobCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintJobRequestBuilder.class, PrintJobCollectionRequest.class);
    }



    /**
     * Gets the raw count request for the collection
     * @return The raw count request for the collection
     */
    @Nonnull
    public PrimitiveRequestBuilder<Long> count() {
        return new PrimitiveRequestBuilder<Long>(getRequestUrlWithAdditionalSegment("$count"), getClient(), null, Long.class);
    }
}
