// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.RemoteAssistancePartnerDisconnectRequest;
import com.microsoft.graph.models.RemoteAssistancePartner;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Remote Assistance Partner Disconnect Request Builder.
 */
public class RemoteAssistancePartnerDisconnectRequestBuilder extends BaseActionRequestBuilder<RemoteAssistancePartner> {

    /**
     * The request builder for this RemoteAssistancePartnerDisconnect
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RemoteAssistancePartnerDisconnectRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the RemoteAssistancePartnerDisconnectRequest
     *
     * @param requestOptions the options for the request
     * @return the RemoteAssistancePartnerDisconnectRequest instance
     */
    @Nonnull
    public RemoteAssistancePartnerDisconnectRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the RemoteAssistancePartnerDisconnectRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the RemoteAssistancePartnerDisconnectRequest instance
     */
    @Nonnull
    public RemoteAssistancePartnerDisconnectRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final RemoteAssistancePartnerDisconnectRequest request = new RemoteAssistancePartnerDisconnectRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
