// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.RichLongRunningOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Rich Long Running Operation Request.
 */
public class RichLongRunningOperationRequest extends BaseRequest<RichLongRunningOperation> {
	
    /**
     * The request for the RichLongRunningOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RichLongRunningOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, RichLongRunningOperation.class);
    }

    /**
     * Gets the RichLongRunningOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RichLongRunningOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the RichLongRunningOperation from the service
     *
     * @return the RichLongRunningOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RichLongRunningOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RichLongRunningOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public RichLongRunningOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this RichLongRunningOperation with a source
     *
     * @param sourceRichLongRunningOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RichLongRunningOperation> patchAsync(@Nonnull final RichLongRunningOperation sourceRichLongRunningOperation) {
        return sendAsync(HttpMethod.PATCH, sourceRichLongRunningOperation);
    }

    /**
     * Patches this RichLongRunningOperation with a source
     *
     * @param sourceRichLongRunningOperation the source object with updates
     * @return the updated RichLongRunningOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RichLongRunningOperation patch(@Nonnull final RichLongRunningOperation sourceRichLongRunningOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceRichLongRunningOperation);
    }

    /**
     * Creates a RichLongRunningOperation with a new object
     *
     * @param newRichLongRunningOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RichLongRunningOperation> postAsync(@Nonnull final RichLongRunningOperation newRichLongRunningOperation) {
        return sendAsync(HttpMethod.POST, newRichLongRunningOperation);
    }

    /**
     * Creates a RichLongRunningOperation with a new object
     *
     * @param newRichLongRunningOperation the new object to create
     * @return the created RichLongRunningOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RichLongRunningOperation post(@Nonnull final RichLongRunningOperation newRichLongRunningOperation) throws ClientException {
        return send(HttpMethod.POST, newRichLongRunningOperation);
    }

    /**
     * Creates a RichLongRunningOperation with a new object
     *
     * @param newRichLongRunningOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RichLongRunningOperation> putAsync(@Nonnull final RichLongRunningOperation newRichLongRunningOperation) {
        return sendAsync(HttpMethod.PUT, newRichLongRunningOperation);
    }

    /**
     * Creates a RichLongRunningOperation with a new object
     *
     * @param newRichLongRunningOperation the object to create/update
     * @return the created RichLongRunningOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RichLongRunningOperation put(@Nonnull final RichLongRunningOperation newRichLongRunningOperation) throws ClientException {
        return send(HttpMethod.PUT, newRichLongRunningOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public RichLongRunningOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public RichLongRunningOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

