// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SwapShiftsChangeRequest;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Swap Shifts Change Request Request.
 */
public class SwapShiftsChangeRequestRequest extends BaseRequest<SwapShiftsChangeRequest> {
	
    /**
     * The request for the SwapShiftsChangeRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SwapShiftsChangeRequestRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SwapShiftsChangeRequest.class);
    }

    /**
     * Gets the SwapShiftsChangeRequest from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SwapShiftsChangeRequest> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SwapShiftsChangeRequest from the service
     *
     * @return the SwapShiftsChangeRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SwapShiftsChangeRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SwapShiftsChangeRequest> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SwapShiftsChangeRequest delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SwapShiftsChangeRequest with a source
     *
     * @param sourceSwapShiftsChangeRequest the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SwapShiftsChangeRequest> patchAsync(@Nonnull final SwapShiftsChangeRequest sourceSwapShiftsChangeRequest) {
        return sendAsync(HttpMethod.PATCH, sourceSwapShiftsChangeRequest);
    }

    /**
     * Patches this SwapShiftsChangeRequest with a source
     *
     * @param sourceSwapShiftsChangeRequest the source object with updates
     * @return the updated SwapShiftsChangeRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SwapShiftsChangeRequest patch(@Nonnull final SwapShiftsChangeRequest sourceSwapShiftsChangeRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourceSwapShiftsChangeRequest);
    }

    /**
     * Creates a SwapShiftsChangeRequest with a new object
     *
     * @param newSwapShiftsChangeRequest the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SwapShiftsChangeRequest> postAsync(@Nonnull final SwapShiftsChangeRequest newSwapShiftsChangeRequest) {
        return sendAsync(HttpMethod.POST, newSwapShiftsChangeRequest);
    }

    /**
     * Creates a SwapShiftsChangeRequest with a new object
     *
     * @param newSwapShiftsChangeRequest the new object to create
     * @return the created SwapShiftsChangeRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SwapShiftsChangeRequest post(@Nonnull final SwapShiftsChangeRequest newSwapShiftsChangeRequest) throws ClientException {
        return send(HttpMethod.POST, newSwapShiftsChangeRequest);
    }

    /**
     * Creates a SwapShiftsChangeRequest with a new object
     *
     * @param newSwapShiftsChangeRequest the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SwapShiftsChangeRequest> putAsync(@Nonnull final SwapShiftsChangeRequest newSwapShiftsChangeRequest) {
        return sendAsync(HttpMethod.PUT, newSwapShiftsChangeRequest);
    }

    /**
     * Creates a SwapShiftsChangeRequest with a new object
     *
     * @param newSwapShiftsChangeRequest the object to create/update
     * @return the created SwapShiftsChangeRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SwapShiftsChangeRequest put(@Nonnull final SwapShiftsChangeRequest newSwapShiftsChangeRequest) throws ClientException {
        return send(HttpMethod.PUT, newSwapShiftsChangeRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SwapShiftsChangeRequestRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SwapShiftsChangeRequestRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

