// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ThumbnailSet;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Thumbnail Set Request.
 */
public class ThumbnailSetRequest extends BaseRequest<ThumbnailSet> {
	
    /**
     * The request for the ThumbnailSet
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ThumbnailSetRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ThumbnailSet.class);
    }

    /**
     * Gets the ThumbnailSet from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThumbnailSet> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ThumbnailSet from the service
     *
     * @return the ThumbnailSet from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ThumbnailSet get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThumbnailSet> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ThumbnailSet delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ThumbnailSet with a source
     *
     * @param sourceThumbnailSet the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThumbnailSet> patchAsync(@Nonnull final ThumbnailSet sourceThumbnailSet) {
        return sendAsync(HttpMethod.PATCH, sourceThumbnailSet);
    }

    /**
     * Patches this ThumbnailSet with a source
     *
     * @param sourceThumbnailSet the source object with updates
     * @return the updated ThumbnailSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ThumbnailSet patch(@Nonnull final ThumbnailSet sourceThumbnailSet) throws ClientException {
        return send(HttpMethod.PATCH, sourceThumbnailSet);
    }

    /**
     * Creates a ThumbnailSet with a new object
     *
     * @param newThumbnailSet the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThumbnailSet> postAsync(@Nonnull final ThumbnailSet newThumbnailSet) {
        return sendAsync(HttpMethod.POST, newThumbnailSet);
    }

    /**
     * Creates a ThumbnailSet with a new object
     *
     * @param newThumbnailSet the new object to create
     * @return the created ThumbnailSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ThumbnailSet post(@Nonnull final ThumbnailSet newThumbnailSet) throws ClientException {
        return send(HttpMethod.POST, newThumbnailSet);
    }

    /**
     * Creates a ThumbnailSet with a new object
     *
     * @param newThumbnailSet the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThumbnailSet> putAsync(@Nonnull final ThumbnailSet newThumbnailSet) {
        return sendAsync(HttpMethod.PUT, newThumbnailSet);
    }

    /**
     * Creates a ThumbnailSet with a new object
     *
     * @param newThumbnailSet the object to create/update
     * @return the created ThumbnailSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ThumbnailSet put(@Nonnull final ThumbnailSet newThumbnailSet) throws ClientException {
        return send(HttpMethod.PUT, newThumbnailSet);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ThumbnailSetRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ThumbnailSetRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

