/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Calendar;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.CalendarCollectionPage;
import com.microsoft.graph.requests.CalendarCollectionRequestBuilder;
import com.microsoft.graph.requests.CalendarCollectionResponse;
import com.microsoft.graph.requests.CalendarRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CalendarCollectionRequest
extends BaseEntityCollectionRequest<Calendar, CalendarCollectionResponse, CalendarCollectionPage> {
    public CalendarCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CalendarCollectionResponse.class, CalendarCollectionPage.class, CalendarCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Calendar> postAsync(@Nonnull Calendar newCalendar) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CalendarRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newCalendar);
    }

    @Nonnull
    public Calendar post(@Nonnull Calendar newCalendar) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CalendarRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCalendar);
    }

    @Nonnull
    public CalendarCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CalendarCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public CalendarCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public CalendarCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public CalendarCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public CalendarCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public CalendarCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public CalendarCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public CalendarCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

