/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.IdentityContainer;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IdentityContainerRequest
extends BaseRequest<IdentityContainer> {
    public IdentityContainerRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, IdentityContainer.class);
    }

    @Nonnull
    public CompletableFuture<IdentityContainer> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public IdentityContainer get() throws ClientException {
        return (IdentityContainer)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<IdentityContainer> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public IdentityContainer delete() throws ClientException {
        return (IdentityContainer)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<IdentityContainer> patchAsync(@Nonnull IdentityContainer sourceIdentityContainer) {
        return this.sendAsync(HttpMethod.PATCH, sourceIdentityContainer);
    }

    @Nullable
    public IdentityContainer patch(@Nonnull IdentityContainer sourceIdentityContainer) throws ClientException {
        return (IdentityContainer)this.send(HttpMethod.PATCH, sourceIdentityContainer);
    }

    @Nonnull
    public CompletableFuture<IdentityContainer> postAsync(@Nonnull IdentityContainer newIdentityContainer) {
        return this.sendAsync(HttpMethod.POST, newIdentityContainer);
    }

    @Nullable
    public IdentityContainer post(@Nonnull IdentityContainer newIdentityContainer) throws ClientException {
        return (IdentityContainer)this.send(HttpMethod.POST, newIdentityContainer);
    }

    @Nonnull
    public CompletableFuture<IdentityContainer> putAsync(@Nonnull IdentityContainer newIdentityContainer) {
        return this.sendAsync(HttpMethod.PUT, newIdentityContainer);
    }

    @Nullable
    public IdentityContainer put(@Nonnull IdentityContainer newIdentityContainer) throws ClientException {
        return (IdentityContainer)this.send(HttpMethod.PUT, newIdentityContainer);
    }

    @Nonnull
    public IdentityContainerRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public IdentityContainerRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

