/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.ItemActivity;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ItemActivityCollectionPage;
import com.microsoft.graph.requests.ItemActivityCollectionRequestBuilder;
import com.microsoft.graph.requests.ItemActivityCollectionResponse;
import com.microsoft.graph.requests.ItemActivityRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ItemActivityCollectionRequest
extends BaseEntityCollectionRequest<ItemActivity, ItemActivityCollectionResponse, ItemActivityCollectionPage> {
    public ItemActivityCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ItemActivityCollectionResponse.class, ItemActivityCollectionPage.class, ItemActivityCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<ItemActivity> postAsync(@Nonnull ItemActivity newItemActivity) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ItemActivityRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newItemActivity);
    }

    @Nonnull
    public ItemActivity post(@Nonnull ItemActivity newItemActivity) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ItemActivityRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newItemActivity);
    }

    @Nonnull
    public ItemActivityCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ItemActivityCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ItemActivityCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ItemActivityCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ItemActivityCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ItemActivityCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ItemActivityCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ItemActivityCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ItemActivityCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

