/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.ListItemVersion;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ListItemVersionCollectionPage;
import com.microsoft.graph.requests.ListItemVersionCollectionRequestBuilder;
import com.microsoft.graph.requests.ListItemVersionCollectionResponse;
import com.microsoft.graph.requests.ListItemVersionRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ListItemVersionCollectionRequest
extends BaseEntityCollectionRequest<ListItemVersion, ListItemVersionCollectionResponse, ListItemVersionCollectionPage> {
    public ListItemVersionCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ListItemVersionCollectionResponse.class, ListItemVersionCollectionPage.class, ListItemVersionCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<ListItemVersion> postAsync(@Nonnull ListItemVersion newListItemVersion) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ListItemVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newListItemVersion);
    }

    @Nonnull
    public ListItemVersion post(@Nonnull ListItemVersion newListItemVersion) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ListItemVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newListItemVersion);
    }

    @Nonnull
    public ListItemVersionCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ListItemVersionCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ListItemVersionCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ListItemVersionCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ListItemVersionCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ListItemVersionCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ListItemVersionCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ListItemVersionCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ListItemVersionCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

