// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.EmailSettings;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Lifecycle Management Settings.
 */
public class LifecycleManagementSettings extends Entity implements IJsonBackedObject {


    /**
     * The Email Settings.
     * Defines the settings for emails sent out from email-specific tasks within workflows. Accepts 2 parameterssenderDomain- Defines the domain of who is sending the email. useCompanyBranding- A boolean value that defines if company branding is to be used with the email.
     */
    @SerializedName(value = "emailSettings", alternate = {"EmailSettings"})
    @Expose
	@Nullable
    public EmailSettings emailSettings;

    /**
     * The Workflow Schedule Interval In Hours.
     * The interval in hours at which all workflows running in the tenant should be scheduled for execution. This interval has a minimum value of 1 and a maximum value of 24. The default value is 3 hours.
     */
    @SerializedName(value = "workflowScheduleIntervalInHours", alternate = {"WorkflowScheduleIntervalInHours"})
    @Expose
	@Nullable
    public Integer workflowScheduleIntervalInHours;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
