// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Run Summary.
 */
public class RunSummary implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Failed Runs.
     * The number of failed workflow runs.
     */
    @SerializedName(value = "failedRuns", alternate = {"FailedRuns"})
    @Expose
	@Nullable
    public Integer failedRuns;

    /**
     * The Failed Tasks.
     * The number of failed tasks of a workflow.
     */
    @SerializedName(value = "failedTasks", alternate = {"FailedTasks"})
    @Expose
	@Nullable
    public Integer failedTasks;

    /**
     * The Successful Runs.
     * The number of successful workflow runs.
     */
    @SerializedName(value = "successfulRuns", alternate = {"SuccessfulRuns"})
    @Expose
	@Nullable
    public Integer successfulRuns;

    /**
     * The Total Runs.
     * The total number of runs for a workflow.
     */
    @SerializedName(value = "totalRuns", alternate = {"TotalRuns"})
    @Expose
	@Nullable
    public Integer totalRuns;

    /**
     * The Total Tasks.
     * The total number of tasks processed by a workflow.
     */
    @SerializedName(value = "totalTasks", alternate = {"TotalTasks"})
    @Expose
	@Nullable
    public Integer totalTasks;

    /**
     * The Total Users.
     * The total number of users processed by a workflow.
     */
    @SerializedName(value = "totalUsers", alternate = {"TotalUsers"})
    @Expose
	@Nullable
    public Integer totalUsers;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
