// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.identitygovernance.models.LifecycleWorkflowCategory;
import com.microsoft.graph.identitygovernance.models.WorkflowExecutionConditions;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.identitygovernance.requests.TaskCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workflow Template.
 */
public class WorkflowTemplate extends Entity implements IJsonBackedObject {


    /**
     * The Category.
     * The category of the workflow template. The possible values are: joiner, mover, leaver,unknownFutureValue.Supports $filter(eq, ne) and $orderby.
     */
    @SerializedName(value = "category", alternate = {"Category"})
    @Expose
	@Nullable
    public LifecycleWorkflowCategory category;

    /**
     * The Description.
     * The description of the workflowTemplate.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * The display name of the workflowTemplate.Supports $filter(eq, ne) and $orderby.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Execution Conditions.
     * Conditions describing when to execute the workflow and the criteria to identify in-scope subject set.
     */
    @SerializedName(value = "executionConditions", alternate = {"ExecutionConditions"})
    @Expose
	@Nullable
    public WorkflowExecutionConditions executionConditions;

    /**
     * The Tasks.
     * Represents the configured tasks to execute and their execution sequence within a workflow. This relationship is expanded by default.
     */
    @SerializedName(value = "tasks", alternate = {"Tasks"})
    @Expose
	@Nullable
    public com.microsoft.graph.identitygovernance.requests.TaskCollectionPage tasks;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("tasks")) {
            tasks = serializer.deserializeObject(json.get("tasks"), com.microsoft.graph.identitygovernance.requests.TaskCollectionPage.class);
        }
    }
}
