// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.identitygovernance.models.LifecycleManagementSettings;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Lifecycle Management Settings Request.
 */
public class LifecycleManagementSettingsRequest extends BaseRequest<LifecycleManagementSettings> {
	
    /**
     * The request for the LifecycleManagementSettings
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public LifecycleManagementSettingsRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, LifecycleManagementSettings.class);
    }

    /**
     * Gets the LifecycleManagementSettings from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LifecycleManagementSettings> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the LifecycleManagementSettings from the service
     *
     * @return the LifecycleManagementSettings from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LifecycleManagementSettings get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LifecycleManagementSettings> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public LifecycleManagementSettings delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this LifecycleManagementSettings with a source
     *
     * @param sourceLifecycleManagementSettings the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LifecycleManagementSettings> patchAsync(@Nonnull final LifecycleManagementSettings sourceLifecycleManagementSettings) {
        return sendAsync(HttpMethod.PATCH, sourceLifecycleManagementSettings);
    }

    /**
     * Patches this LifecycleManagementSettings with a source
     *
     * @param sourceLifecycleManagementSettings the source object with updates
     * @return the updated LifecycleManagementSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LifecycleManagementSettings patch(@Nonnull final LifecycleManagementSettings sourceLifecycleManagementSettings) throws ClientException {
        return send(HttpMethod.PATCH, sourceLifecycleManagementSettings);
    }

    /**
     * Creates a LifecycleManagementSettings with a new object
     *
     * @param newLifecycleManagementSettings the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LifecycleManagementSettings> postAsync(@Nonnull final LifecycleManagementSettings newLifecycleManagementSettings) {
        return sendAsync(HttpMethod.POST, newLifecycleManagementSettings);
    }

    /**
     * Creates a LifecycleManagementSettings with a new object
     *
     * @param newLifecycleManagementSettings the new object to create
     * @return the created LifecycleManagementSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LifecycleManagementSettings post(@Nonnull final LifecycleManagementSettings newLifecycleManagementSettings) throws ClientException {
        return send(HttpMethod.POST, newLifecycleManagementSettings);
    }

    /**
     * Creates a LifecycleManagementSettings with a new object
     *
     * @param newLifecycleManagementSettings the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LifecycleManagementSettings> putAsync(@Nonnull final LifecycleManagementSettings newLifecycleManagementSettings) {
        return sendAsync(HttpMethod.PUT, newLifecycleManagementSettings);
    }

    /**
     * Creates a LifecycleManagementSettings with a new object
     *
     * @param newLifecycleManagementSettings the object to create/update
     * @return the created LifecycleManagementSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LifecycleManagementSettings put(@Nonnull final LifecycleManagementSettings newLifecycleManagementSettings) throws ClientException {
        return send(HttpMethod.PUT, newLifecycleManagementSettings);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public LifecycleManagementSettingsRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public LifecycleManagementSettingsRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

