// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AccessPackageCatalog;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.AccessPackageAssignmentPolicyCollectionPage;
import com.microsoft.graph.requests.GroupCollectionPage;
import com.microsoft.graph.requests.AccessPackageResourceRoleScopeCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package.
 */
public class AccessPackage extends Entity implements IJsonBackedObject {


    /**
     * The Created Date Time.
     * The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Read-only.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Description.
     * The description of the access package.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * Required. The display name of the access package. Supports $filter (eq, contains).
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Is Hidden.
     * Whether the access package is hidden from the requestor.
     */
    @SerializedName(value = "isHidden", alternate = {"IsHidden"})
    @Expose
	@Nullable
    public Boolean isHidden;

    /**
     * The Modified Date Time.
     * The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Read-only.
     */
    @SerializedName(value = "modifiedDateTime", alternate = {"ModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime modifiedDateTime;

    /**
     * The Access Packages Incompatible With.
     * The access packages that are incompatible with this package. Read-only.
     */
	@Nullable
    public com.microsoft.graph.requests.AccessPackageCollectionPage accessPackagesIncompatibleWith;

    /**
     * The Assignment Policies.
     * Read-only. Nullable. Supports $expand.
     */
    @SerializedName(value = "assignmentPolicies", alternate = {"AssignmentPolicies"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.AccessPackageAssignmentPolicyCollectionPage assignmentPolicies;

    /**
     * The Catalog.
     * Required when creating the access package. Read-only. Nullable.
     */
    @SerializedName(value = "catalog", alternate = {"Catalog"})
    @Expose
	@Nullable
    public AccessPackageCatalog catalog;

    /**
     * The Incompatible Access Packages.
     * The access packages whose assigned users are ineligible to be assigned this access package.
     */
	@Nullable
    public com.microsoft.graph.requests.AccessPackageCollectionPage incompatibleAccessPackages;

    /**
     * The Incompatible Groups.
     * The groups whose members are ineligible to be assigned this access package.
     */
    @SerializedName(value = "incompatibleGroups", alternate = {"IncompatibleGroups"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.GroupCollectionPage incompatibleGroups;

    /**
     * The Resource Role Scopes.
     * The resource roles and scopes in this access package.
     */
    @SerializedName(value = "resourceRoleScopes", alternate = {"ResourceRoleScopes"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.AccessPackageResourceRoleScopeCollectionPage resourceRoleScopes;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("accessPackagesIncompatibleWith")) {
            accessPackagesIncompatibleWith = serializer.deserializeObject(json.get("accessPackagesIncompatibleWith"), com.microsoft.graph.requests.AccessPackageCollectionPage.class);
        }

        if (json.has("assignmentPolicies")) {
            assignmentPolicies = serializer.deserializeObject(json.get("assignmentPolicies"), com.microsoft.graph.requests.AccessPackageAssignmentPolicyCollectionPage.class);
        }

        if (json.has("incompatibleAccessPackages")) {
            incompatibleAccessPackages = serializer.deserializeObject(json.get("incompatibleAccessPackages"), com.microsoft.graph.requests.AccessPackageCollectionPage.class);
        }

        if (json.has("incompatibleGroups")) {
            incompatibleGroups = serializer.deserializeObject(json.get("incompatibleGroups"), com.microsoft.graph.requests.GroupCollectionPage.class);
        }

        if (json.has("resourceRoleScopes")) {
            resourceRoleScopes = serializer.deserializeObject(json.get("resourceRoleScopes"), com.microsoft.graph.requests.AccessPackageResourceRoleScopeCollectionPage.class);
        }
    }
}
