// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.AccessPackageAssignment;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Assignment Additional Access Parameter Set.
 */
public class AccessPackageAssignmentAdditionalAccessParameterSet {
    /**
     * The access Package Id.
     * 
     */
    @SerializedName(value = "accessPackageId", alternate = {"AccessPackageId"})
    @Expose
	@Nullable
    public String accessPackageId;

    /**
     * The incompatible Access Package Id.
     * 
     */
    @SerializedName(value = "incompatibleAccessPackageId", alternate = {"IncompatibleAccessPackageId"})
    @Expose
	@Nullable
    public String incompatibleAccessPackageId;


    /**
     * Instiaciates a new AccessPackageAssignmentAdditionalAccessParameterSet
     */
    public AccessPackageAssignmentAdditionalAccessParameterSet() {}
    /**
     * Instiaciates a new AccessPackageAssignmentAdditionalAccessParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected AccessPackageAssignmentAdditionalAccessParameterSet(@Nonnull final AccessPackageAssignmentAdditionalAccessParameterSetBuilder builder) {
        this.accessPackageId = builder.accessPackageId;
        this.incompatibleAccessPackageId = builder.incompatibleAccessPackageId;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static AccessPackageAssignmentAdditionalAccessParameterSetBuilder newBuilder() {
        return new AccessPackageAssignmentAdditionalAccessParameterSetBuilder();
    }
    /**
     * Fluent builder for the AccessPackageAssignmentAdditionalAccessParameterSet
     */
    public static final class AccessPackageAssignmentAdditionalAccessParameterSetBuilder {
        /**
         * The accessPackageId parameter value
         */
        @Nullable
        protected String accessPackageId;
        /**
         * Sets the AccessPackageId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public AccessPackageAssignmentAdditionalAccessParameterSetBuilder withAccessPackageId(@Nullable final String val) {
            this.accessPackageId = val;
            return this;
        }
        /**
         * The incompatibleAccessPackageId parameter value
         */
        @Nullable
        protected String incompatibleAccessPackageId;
        /**
         * Sets the IncompatibleAccessPackageId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public AccessPackageAssignmentAdditionalAccessParameterSetBuilder withIncompatibleAccessPackageId(@Nullable final String val) {
            this.incompatibleAccessPackageId = val;
            return this;
        }
        /**
         * Instanciates a new AccessPackageAssignmentAdditionalAccessParameterSetBuilder
         */
        @Nullable
        protected AccessPackageAssignmentAdditionalAccessParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public AccessPackageAssignmentAdditionalAccessParameterSet build() {
            return new AccessPackageAssignmentAdditionalAccessParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.accessPackageId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("accessPackageId", accessPackageId));
        }
        if(this.incompatibleAccessPackageId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("incompatibleAccessPackageId", incompatibleAccessPackageId));
        }
        return result;
    }
}
