// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Apple Push Notification Certificate.
 */
public class ApplePushNotificationCertificate extends Entity implements IJsonBackedObject {


    /**
     * The Apple Identifier.
     * Apple Id of the account used to create the MDM push certificate.
     */
    @SerializedName(value = "appleIdentifier", alternate = {"AppleIdentifier"})
    @Expose
	@Nullable
    public String appleIdentifier;

    /**
     * The Certificate.
     * Not yet documented
     */
    @SerializedName(value = "certificate", alternate = {"Certificate"})
    @Expose
	@Nullable
    public String certificate;

    /**
     * The Certificate Serial Number.
     * Certificate serial number. This property is read-only.
     */
    @SerializedName(value = "certificateSerialNumber", alternate = {"CertificateSerialNumber"})
    @Expose
	@Nullable
    public String certificateSerialNumber;

    /**
     * The Certificate Upload Failure Reason.
     * The reason the certificate upload failed.
     */
    @SerializedName(value = "certificateUploadFailureReason", alternate = {"CertificateUploadFailureReason"})
    @Expose
	@Nullable
    public String certificateUploadFailureReason;

    /**
     * The Certificate Upload Status.
     * The certificate upload status.
     */
    @SerializedName(value = "certificateUploadStatus", alternate = {"CertificateUploadStatus"})
    @Expose
	@Nullable
    public String certificateUploadStatus;

    /**
     * The Expiration Date Time.
     * The expiration date and time for Apple push notification certificate.
     */
    @SerializedName(value = "expirationDateTime", alternate = {"ExpirationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime expirationDateTime;

    /**
     * The Last Modified Date Time.
     * Last modified date and time for Apple push notification certificate.
     */
    @SerializedName(value = "lastModifiedDateTime", alternate = {"LastModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastModifiedDateTime;

    /**
     * The Topic Identifier.
     * Topic Id.
     */
    @SerializedName(value = "topicIdentifier", alternate = {"TopicIdentifier"})
    @Expose
	@Nullable
    public String topicIdentifier;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
