// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.AttachmentInfo;
import com.microsoft.graph.models.UploadSession;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Attachment Base Create Upload Session Parameter Set.
 */
public class AttachmentBaseCreateUploadSessionParameterSet {
    /**
     * The attachment Info.
     * 
     */
    @SerializedName(value = "attachmentInfo", alternate = {"AttachmentInfo"})
    @Expose
	@Nullable
    public AttachmentInfo attachmentInfo;


    /**
     * Instiaciates a new AttachmentBaseCreateUploadSessionParameterSet
     */
    public AttachmentBaseCreateUploadSessionParameterSet() {}
    /**
     * Instiaciates a new AttachmentBaseCreateUploadSessionParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected AttachmentBaseCreateUploadSessionParameterSet(@Nonnull final AttachmentBaseCreateUploadSessionParameterSetBuilder builder) {
        this.attachmentInfo = builder.attachmentInfo;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static AttachmentBaseCreateUploadSessionParameterSetBuilder newBuilder() {
        return new AttachmentBaseCreateUploadSessionParameterSetBuilder();
    }
    /**
     * Fluent builder for the AttachmentBaseCreateUploadSessionParameterSet
     */
    public static final class AttachmentBaseCreateUploadSessionParameterSetBuilder {
        /**
         * The attachmentInfo parameter value
         */
        @Nullable
        protected AttachmentInfo attachmentInfo;
        /**
         * Sets the AttachmentInfo
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public AttachmentBaseCreateUploadSessionParameterSetBuilder withAttachmentInfo(@Nullable final AttachmentInfo val) {
            this.attachmentInfo = val;
            return this;
        }
        /**
         * Instanciates a new AttachmentBaseCreateUploadSessionParameterSetBuilder
         */
        @Nullable
        protected AttachmentBaseCreateUploadSessionParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public AttachmentBaseCreateUploadSessionParameterSet build() {
            return new AttachmentBaseCreateUploadSessionParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.attachmentInfo != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("attachmentInfo", attachmentInfo));
        }
        return result;
    }
}
