// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.SimulationAutomationCollectionPage;
import com.microsoft.graph.requests.SimulationCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Attack Simulation Root.
 */
public class AttackSimulationRoot extends Entity implements IJsonBackedObject {


    /**
     * The Simulation Automations.
     * Represents simulation automation created to run on a tenant.
     */
    @SerializedName(value = "simulationAutomations", alternate = {"SimulationAutomations"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.SimulationAutomationCollectionPage simulationAutomations;

    /**
     * The Simulations.
     * Represents an attack simulation training campaign in a tenant.
     */
    @SerializedName(value = "simulations", alternate = {"Simulations"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.SimulationCollectionPage simulations;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("simulationAutomations")) {
            simulationAutomations = serializer.deserializeObject(json.get("simulationAutomations"), com.microsoft.graph.requests.SimulationAutomationCollectionPage.class);
        }

        if (json.has("simulations")) {
            simulations = serializer.deserializeObject(json.get("simulations"), com.microsoft.graph.requests.SimulationCollectionPage.class);
        }
    }
}
