// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AttackSimulationUser;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Attack Simulation Simulation User Coverage.
 */
public class AttackSimulationSimulationUserCoverage implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Attack Simulation User.
     * User in an attack simulation and training campaign.
     */
    @SerializedName(value = "attackSimulationUser", alternate = {"AttackSimulationUser"})
    @Expose
	@Nullable
    public AttackSimulationUser attackSimulationUser;

    /**
     * The Click Count.
     * Number of link clicks in the received payloads by the user in attack simulation and training campaigns.
     */
    @SerializedName(value = "clickCount", alternate = {"ClickCount"})
    @Expose
	@Nullable
    public Integer clickCount;

    /**
     * The Compromised Count.
     * Number of compromising actions by the user in attack simulation and training campaigns.
     */
    @SerializedName(value = "compromisedCount", alternate = {"CompromisedCount"})
    @Expose
	@Nullable
    public Integer compromisedCount;

    /**
     * The Latest Simulation Date Time.
     * Date and time of the latest attack simulation and training campaign that the user was included in.
     */
    @SerializedName(value = "latestSimulationDateTime", alternate = {"LatestSimulationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime latestSimulationDateTime;

    /**
     * The Simulation Count.
     * Number of attack simulation and training campaigns that the user was included in.
     */
    @SerializedName(value = "simulationCount", alternate = {"SimulationCount"})
    @Expose
	@Nullable
    public Integer simulationCount;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
