// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.BrowserSite;
import com.microsoft.graph.models.BrowserSharedCookie;
import com.microsoft.graph.models.BrowserSiteList;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Browser Site List Publish Parameter Set.
 */
public class BrowserSiteListPublishParameterSet {
    /**
     * The revision.
     * 
     */
    @SerializedName(value = "revision", alternate = {"Revision"})
    @Expose
	@Nullable
    public String revision;

    /**
     * The sites.
     * 
     */
    @SerializedName(value = "sites", alternate = {"Sites"})
    @Expose
	@Nullable
    public java.util.List<BrowserSite> sites;

    /**
     * The shared Cookies.
     * 
     */
    @SerializedName(value = "sharedCookies", alternate = {"SharedCookies"})
    @Expose
	@Nullable
    public java.util.List<BrowserSharedCookie> sharedCookies;


    /**
     * Instiaciates a new BrowserSiteListPublishParameterSet
     */
    public BrowserSiteListPublishParameterSet() {}
    /**
     * Instiaciates a new BrowserSiteListPublishParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected BrowserSiteListPublishParameterSet(@Nonnull final BrowserSiteListPublishParameterSetBuilder builder) {
        this.revision = builder.revision;
        this.sites = builder.sites;
        this.sharedCookies = builder.sharedCookies;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static BrowserSiteListPublishParameterSetBuilder newBuilder() {
        return new BrowserSiteListPublishParameterSetBuilder();
    }
    /**
     * Fluent builder for the BrowserSiteListPublishParameterSet
     */
    public static final class BrowserSiteListPublishParameterSetBuilder {
        /**
         * The revision parameter value
         */
        @Nullable
        protected String revision;
        /**
         * Sets the Revision
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public BrowserSiteListPublishParameterSetBuilder withRevision(@Nullable final String val) {
            this.revision = val;
            return this;
        }
        /**
         * The sites parameter value
         */
        @Nullable
        protected java.util.List<BrowserSite> sites;
        /**
         * Sets the Sites
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public BrowserSiteListPublishParameterSetBuilder withSites(@Nullable final java.util.List<BrowserSite> val) {
            this.sites = val;
            return this;
        }
        /**
         * The sharedCookies parameter value
         */
        @Nullable
        protected java.util.List<BrowserSharedCookie> sharedCookies;
        /**
         * Sets the SharedCookies
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public BrowserSiteListPublishParameterSetBuilder withSharedCookies(@Nullable final java.util.List<BrowserSharedCookie> val) {
            this.sharedCookies = val;
            return this;
        }
        /**
         * Instanciates a new BrowserSiteListPublishParameterSetBuilder
         */
        @Nullable
        protected BrowserSiteListPublishParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public BrowserSiteListPublishParameterSet build() {
            return new BrowserSiteListPublishParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.revision != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("revision", revision));
        }
        if(this.sites != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("sites", sites));
        }
        if(this.sharedCookies != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("sharedCookies", sharedCookies));
        }
        return result;
    }
}
