// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AssignmentType;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.LearningCourseActivity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Learning Assignment.
 */
public class LearningAssignment extends LearningCourseActivity implements IJsonBackedObject {


    /**
     * The Assigned Date Time.
     * Assigned date for the course activity. Optional.
     */
    @SerializedName(value = "assignedDateTime", alternate = {"AssignedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime assignedDateTime;

    /**
     * The Assigner User Id.
     * The user ID of the assigner. Optional.
     */
    @SerializedName(value = "assignerUserId", alternate = {"AssignerUserId"})
    @Expose
	@Nullable
    public String assignerUserId;

    /**
     * The Assignment Type.
     * The assignment type for the course activity. Possible values are: required, recommended, unknownFutureValue. Required.
     */
    @SerializedName(value = "assignmentType", alternate = {"AssignmentType"})
    @Expose
	@Nullable
    public AssignmentType assignmentType;

    /**
     * The Due Date Time.
     * Due date for the course activity. Optional.
     */
    @SerializedName(value = "dueDateTime", alternate = {"DueDateTime"})
    @Expose
	@Nullable
    public DateTimeTimeZone dueDateTime;

    /**
     * The Notes.
     * Notes for the course activity. Optional.
     */
    @SerializedName(value = "notes", alternate = {"Notes"})
    @Expose
	@Nullable
    public ItemBody notes;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
