// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.LayoutTemplateType;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Login Page Layout Configuration.
 */
public class LoginPageLayoutConfiguration implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Is Footer Shown.
     * Option to show the footer on the sign-in page.
     */
    @SerializedName(value = "isFooterShown", alternate = {"IsFooterShown"})
    @Expose
	@Nullable
    public Boolean isFooterShown;

    /**
     * The Is Header Shown.
     * Option to show the header on the sign-in page.
     */
    @SerializedName(value = "isHeaderShown", alternate = {"IsHeaderShown"})
    @Expose
	@Nullable
    public Boolean isHeaderShown;

    /**
     * The Layout Template Type.
     * Represents the layout template to be displayed on the login page for a tenant. The possible values are  default - Represents the default Microsoft layout with a centered lightbox.  verticalSplit - Represents a layout with a backgound on the left side and a full-height lightbox to the right.  unknownFutureValue - Evolvable enumeration sentinel value. Do not use.
     */
    @SerializedName(value = "layoutTemplateType", alternate = {"LayoutTemplateType"})
    @Expose
	@Nullable
    public LayoutTemplateType layoutTemplateType;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
