// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.Device;
import com.microsoft.graph.models.AuthenticationMethod;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Microsoft Authenticator Authentication Method.
 */
public class MicrosoftAuthenticatorAuthenticationMethod extends AuthenticationMethod implements IJsonBackedObject {


    /**
     * The Created Date Time.
     * The date and time that this app was registered. This property is null if the device is not registered for passwordless Phone Sign-In.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Device Tag.
     * Tags containing app metadata.
     */
    @SerializedName(value = "deviceTag", alternate = {"DeviceTag"})
    @Expose
	@Nullable
    public String deviceTag;

    /**
     * The Display Name.
     * The name of the device on which this app is registered.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Phone App Version.
     * Numerical version of this instance of the Authenticator app.
     */
    @SerializedName(value = "phoneAppVersion", alternate = {"PhoneAppVersion"})
    @Expose
	@Nullable
    public String phoneAppVersion;

    /**
     * The Device.
     * The registered device on which Microsoft Authenticator resides. This property is null if the device is not registered for passwordless Phone Sign-In.
     */
    @SerializedName(value = "device", alternate = {"Device"})
    @Expose
	@Nullable
    public Device device;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
