// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Job Abort Parameter Set.
 */
public class PrintJobAbortParameterSet {
    /**
     * The reason.
     * 
     */
    @SerializedName(value = "reason", alternate = {"Reason"})
    @Expose
	@Nullable
    public String reason;


    /**
     * Instiaciates a new PrintJobAbortParameterSet
     */
    public PrintJobAbortParameterSet() {}
    /**
     * Instiaciates a new PrintJobAbortParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected PrintJobAbortParameterSet(@Nonnull final PrintJobAbortParameterSetBuilder builder) {
        this.reason = builder.reason;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static PrintJobAbortParameterSetBuilder newBuilder() {
        return new PrintJobAbortParameterSetBuilder();
    }
    /**
     * Fluent builder for the PrintJobAbortParameterSet
     */
    public static final class PrintJobAbortParameterSetBuilder {
        /**
         * The reason parameter value
         */
        @Nullable
        protected String reason;
        /**
         * Sets the Reason
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PrintJobAbortParameterSetBuilder withReason(@Nullable final String val) {
            this.reason = val;
            return this;
        }
        /**
         * Instanciates a new PrintJobAbortParameterSetBuilder
         */
        @Nullable
        protected PrintJobAbortParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public PrintJobAbortParameterSet build() {
            return new PrintJobAbortParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.reason != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("reason", reason));
        }
        return result;
    }
}
