// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.PrintColorMode;
import com.microsoft.graph.models.PrintDuplexMode;
import com.microsoft.graph.models.PrintFinishing;
import com.microsoft.graph.models.PrintMultipageLayout;
import com.microsoft.graph.models.PrintOrientation;
import com.microsoft.graph.models.PrintQuality;
import com.microsoft.graph.models.PrintScaling;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Printer Defaults.
 */
public class PrinterDefaults implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Color Mode.
     * The default color mode to use when printing the document. Valid values are described in the following table.
     */
    @SerializedName(value = "colorMode", alternate = {"ColorMode"})
    @Expose
	@Nullable
    public PrintColorMode colorMode;

    /**
     * The Content Type.
     * The default content (MIME) type to use when processing documents.
     */
    @SerializedName(value = "contentType", alternate = {"ContentType"})
    @Expose
	@Nullable
    public String contentType;

    /**
     * The Copies Per Job.
     * The default number of copies printed per job.
     */
    @SerializedName(value = "copiesPerJob", alternate = {"CopiesPerJob"})
    @Expose
	@Nullable
    public Integer copiesPerJob;

    /**
     * The Dpi.
     * The default resolution in DPI to use when printing the job.
     */
    @SerializedName(value = "dpi", alternate = {"Dpi"})
    @Expose
	@Nullable
    public Integer dpi;

    /**
     * The Duplex Mode.
     * The default duplex (double-sided) configuration to use when printing a document. Valid values are described in the following table.
     */
    @SerializedName(value = "duplexMode", alternate = {"DuplexMode"})
    @Expose
	@Nullable
    public PrintDuplexMode duplexMode;

    /**
     * The Finishings.
     * The default set of finishings to apply to print jobs. Valid values are described in the following table.
     */
    @SerializedName(value = "finishings", alternate = {"Finishings"})
    @Expose
	@Nullable
    public java.util.List<PrintFinishing> finishings;

    /**
     * The Fit Pdf To Page.
     * The default fitPdfToPage setting. True to fit each page of a PDF document to a physical sheet of media; false to let the printer decide how to lay out impressions.
     */
    @SerializedName(value = "fitPdfToPage", alternate = {"FitPdfToPage"})
    @Expose
	@Nullable
    public Boolean fitPdfToPage;

    /**
     * The Input Bin.
     * 
     */
    @SerializedName(value = "inputBin", alternate = {"InputBin"})
    @Expose
	@Nullable
    public String inputBin;

    /**
     * The Media Color.
     * The default media (such as paper) color to print the document on.
     */
    @SerializedName(value = "mediaColor", alternate = {"MediaColor"})
    @Expose
	@Nullable
    public String mediaColor;

    /**
     * The Media Size.
     * The default media size to use. Supports standard size names for ISO and ANSI media sizes. Valid values are listed in the printerCapabilities topic.
     */
    @SerializedName(value = "mediaSize", alternate = {"MediaSize"})
    @Expose
	@Nullable
    public String mediaSize;

    /**
     * The Media Type.
     * The default media (such as paper) type to print the document on.
     */
    @SerializedName(value = "mediaType", alternate = {"MediaType"})
    @Expose
	@Nullable
    public String mediaType;

    /**
     * The Multipage Layout.
     * The default direction to lay out pages when multiple pages are being printed per sheet. Valid values are described in the following table.
     */
    @SerializedName(value = "multipageLayout", alternate = {"MultipageLayout"})
    @Expose
	@Nullable
    public PrintMultipageLayout multipageLayout;

    /**
     * The Orientation.
     * The default orientation to use when printing the document. Valid values are described in the following table.
     */
    @SerializedName(value = "orientation", alternate = {"Orientation"})
    @Expose
	@Nullable
    public PrintOrientation orientation;

    /**
     * The Output Bin.
     * The default output bin to place completed prints into. See the printer's capabilities for a list of supported output bins.
     */
    @SerializedName(value = "outputBin", alternate = {"OutputBin"})
    @Expose
	@Nullable
    public String outputBin;

    /**
     * The Pages Per Sheet.
     * The default number of document pages to print on each sheet.
     */
    @SerializedName(value = "pagesPerSheet", alternate = {"PagesPerSheet"})
    @Expose
	@Nullable
    public Integer pagesPerSheet;

    /**
     * The Quality.
     * The default quality to use when printing the document. Valid values are described in the following table.
     */
    @SerializedName(value = "quality", alternate = {"Quality"})
    @Expose
	@Nullable
    public PrintQuality quality;

    /**
     * The Scaling.
     * Specifies how the printer scales the document data to fit the requested media. Valid values are described in the following table.
     */
    @SerializedName(value = "scaling", alternate = {"Scaling"})
    @Expose
	@Nullable
    public PrintScaling scaling;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
