// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Risky Service Principal Dismiss Parameter Set.
 */
public class RiskyServicePrincipalDismissParameterSet {
    /**
     * The service Principal Ids.
     * 
     */
    @SerializedName(value = "servicePrincipalIds", alternate = {"ServicePrincipalIds"})
    @Expose
	@Nullable
    public java.util.List<String> servicePrincipalIds;


    /**
     * Instiaciates a new RiskyServicePrincipalDismissParameterSet
     */
    public RiskyServicePrincipalDismissParameterSet() {}
    /**
     * Instiaciates a new RiskyServicePrincipalDismissParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected RiskyServicePrincipalDismissParameterSet(@Nonnull final RiskyServicePrincipalDismissParameterSetBuilder builder) {
        this.servicePrincipalIds = builder.servicePrincipalIds;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static RiskyServicePrincipalDismissParameterSetBuilder newBuilder() {
        return new RiskyServicePrincipalDismissParameterSetBuilder();
    }
    /**
     * Fluent builder for the RiskyServicePrincipalDismissParameterSet
     */
    public static final class RiskyServicePrincipalDismissParameterSetBuilder {
        /**
         * The servicePrincipalIds parameter value
         */
        @Nullable
        protected java.util.List<String> servicePrincipalIds;
        /**
         * Sets the ServicePrincipalIds
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public RiskyServicePrincipalDismissParameterSetBuilder withServicePrincipalIds(@Nullable final java.util.List<String> val) {
            this.servicePrincipalIds = val;
            return this;
        }
        /**
         * Instanciates a new RiskyServicePrincipalDismissParameterSetBuilder
         */
        @Nullable
        protected RiskyServicePrincipalDismissParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public RiskyServicePrincipalDismissParameterSet build() {
            return new RiskyServicePrincipalDismissParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.servicePrincipalIds != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("servicePrincipalIds", servicePrincipalIds));
        }
        return result;
    }
}
