// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.RiskServicePrincipalActivity;
import com.microsoft.graph.models.RiskyServicePrincipal;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Risky Service Principal History Item.
 */
public class RiskyServicePrincipalHistoryItem extends RiskyServicePrincipal implements IJsonBackedObject {


    /**
     * The Activity.
     * The activity related to service principal risk level change.
     */
    @SerializedName(value = "activity", alternate = {"Activity"})
    @Expose
	@Nullable
    public RiskServicePrincipalActivity activity;

    /**
     * The Initiated By.
     * The identifier of the actor of the operation.
     */
    @SerializedName(value = "initiatedBy", alternate = {"InitiatedBy"})
    @Expose
	@Nullable
    public String initiatedBy;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
