// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.SelfSignedCertificate;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Principal Add Token Signing Certificate Parameter Set.
 */
public class ServicePrincipalAddTokenSigningCertificateParameterSet {
    /**
     * The display Name.
     * 
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The end Date Time.
     * 
     */
    @SerializedName(value = "endDateTime", alternate = {"EndDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime endDateTime;


    /**
     * Instiaciates a new ServicePrincipalAddTokenSigningCertificateParameterSet
     */
    public ServicePrincipalAddTokenSigningCertificateParameterSet() {}
    /**
     * Instiaciates a new ServicePrincipalAddTokenSigningCertificateParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ServicePrincipalAddTokenSigningCertificateParameterSet(@Nonnull final ServicePrincipalAddTokenSigningCertificateParameterSetBuilder builder) {
        this.displayName = builder.displayName;
        this.endDateTime = builder.endDateTime;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ServicePrincipalAddTokenSigningCertificateParameterSetBuilder newBuilder() {
        return new ServicePrincipalAddTokenSigningCertificateParameterSetBuilder();
    }
    /**
     * Fluent builder for the ServicePrincipalAddTokenSigningCertificateParameterSet
     */
    public static final class ServicePrincipalAddTokenSigningCertificateParameterSetBuilder {
        /**
         * The displayName parameter value
         */
        @Nullable
        protected String displayName;
        /**
         * Sets the DisplayName
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ServicePrincipalAddTokenSigningCertificateParameterSetBuilder withDisplayName(@Nullable final String val) {
            this.displayName = val;
            return this;
        }
        /**
         * The endDateTime parameter value
         */
        @Nullable
        protected java.time.OffsetDateTime endDateTime;
        /**
         * Sets the EndDateTime
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ServicePrincipalAddTokenSigningCertificateParameterSetBuilder withEndDateTime(@Nullable final java.time.OffsetDateTime val) {
            this.endDateTime = val;
            return this;
        }
        /**
         * Instanciates a new ServicePrincipalAddTokenSigningCertificateParameterSetBuilder
         */
        @Nullable
        protected ServicePrincipalAddTokenSigningCertificateParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ServicePrincipalAddTokenSigningCertificateParameterSet build() {
            return new ServicePrincipalAddTokenSigningCertificateParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.displayName != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("displayName", displayName));
        }
        if(this.endDateTime != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("endDateTime", endDateTime));
        }
        return result;
    }
}
