// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.RecommendedAction;
import com.microsoft.graph.models.SimulationEventsContent;
import com.microsoft.graph.models.TrainingEventsContent;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Simulation Report Overview.
 */
public class SimulationReportOverview implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Recommended Actions.
     * List of recommended actions for a tenant to improve its security posture based on the attack simulation and training campaign attack type.
     */
    @SerializedName(value = "recommendedActions", alternate = {"RecommendedActions"})
    @Expose
	@Nullable
    public java.util.List<RecommendedAction> recommendedActions;

    /**
     * The Resolved Targets Count.
     * Number of valid users in the attack simulation and training campaign.
     */
    @SerializedName(value = "resolvedTargetsCount", alternate = {"ResolvedTargetsCount"})
    @Expose
	@Nullable
    public Integer resolvedTargetsCount;

    /**
     * The Simulation Events Content.
     * Summary of simulation events in the attack simulation and training campaign.
     */
    @SerializedName(value = "simulationEventsContent", alternate = {"SimulationEventsContent"})
    @Expose
	@Nullable
    public SimulationEventsContent simulationEventsContent;

    /**
     * The Training Events Content.
     * Summary of assigned trainings in the attack simulation and training campaign.
     */
    @SerializedName(value = "trainingEventsContent", alternate = {"TrainingEventsContent"})
    @Expose
	@Nullable
    public TrainingEventsContent trainingEventsContent;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
