// Template Source: Enum.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


/**
 * The Enum Synchronization Metadata.
*/
public enum SynchronizationMetadata
{
    /**
    * Gallery Application Identifier
    */
    GALLERY_APPLICATION_IDENTIFIER,
    /**
    * Gallery Application Key
    */
    GALLERY_APPLICATION_KEY,
    /**
    * Is OAuth Enabled
    */
    IS_O_AUTH_ENABLED,
    /**
    * Is Synchronization Agent Assignment Required
    */
    IS_SYNCHRONIZATION_AGENT_ASSIGNMENT_REQUIRED,
    /**
    * Is Synchronization Agent Required
    */
    IS_SYNCHRONIZATION_AGENT_REQUIRED,
    /**
    * Is Synchronization In Preview
    */
    IS_SYNCHRONIZATION_IN_PREVIEW,
    /**
    * OAuth Settings
    */
    O_AUTH_SETTINGS,
    /**
    * Synchronization Learn More Ibiza Fw Link
    */
    SYNCHRONIZATION_LEARN_MORE_IBIZA_FW_LINK,
    /**
    * Configuration Fields
    */
    CONFIGURATION_FIELDS,
    /**
    * For SynchronizationMetadata values that were not expected from the service
    */
    UNEXPECTED_VALUE
}
