// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.RoleAssignmentScheduleInstanceFilterByCurrentUserOptions;
import com.microsoft.graph.models.UnifiedRoleAssignmentScheduleInstance;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Assignment Schedule Instance Filter By Current User Parameter Set.
 */
public class UnifiedRoleAssignmentScheduleInstanceFilterByCurrentUserParameterSet {
    /**
     * The on.
     * 
     */
    @SerializedName(value = "on", alternate = {"On"})
    @Expose
	@Nullable
    public RoleAssignmentScheduleInstanceFilterByCurrentUserOptions on;


    /**
     * Instiaciates a new UnifiedRoleAssignmentScheduleInstanceFilterByCurrentUserParameterSet
     */
    public UnifiedRoleAssignmentScheduleInstanceFilterByCurrentUserParameterSet() {}
    /**
     * Instiaciates a new UnifiedRoleAssignmentScheduleInstanceFilterByCurrentUserParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected UnifiedRoleAssignmentScheduleInstanceFilterByCurrentUserParameterSet(@Nonnull final UnifiedRoleAssignmentScheduleInstanceFilterByCurrentUserParameterSetBuilder builder) {
        this.on = builder.on;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static UnifiedRoleAssignmentScheduleInstanceFilterByCurrentUserParameterSetBuilder newBuilder() {
        return new UnifiedRoleAssignmentScheduleInstanceFilterByCurrentUserParameterSetBuilder();
    }
    /**
     * Fluent builder for the UnifiedRoleAssignmentScheduleInstanceFilterByCurrentUserParameterSet
     */
    public static final class UnifiedRoleAssignmentScheduleInstanceFilterByCurrentUserParameterSetBuilder {
        /**
         * The on parameter value
         */
        @Nullable
        protected RoleAssignmentScheduleInstanceFilterByCurrentUserOptions on;
        /**
         * Sets the On
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public UnifiedRoleAssignmentScheduleInstanceFilterByCurrentUserParameterSetBuilder withOn(@Nullable final RoleAssignmentScheduleInstanceFilterByCurrentUserOptions val) {
            this.on = val;
            return this;
        }
        /**
         * Instanciates a new UnifiedRoleAssignmentScheduleInstanceFilterByCurrentUserParameterSetBuilder
         */
        @Nullable
        protected UnifiedRoleAssignmentScheduleInstanceFilterByCurrentUserParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public UnifiedRoleAssignmentScheduleInstanceFilterByCurrentUserParameterSet build() {
            return new UnifiedRoleAssignmentScheduleInstanceFilterByCurrentUserParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.on != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("on", on));
        }
        return result;
    }
}
