// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.MiracastChannel;
import com.microsoft.graph.models.WelcomeScreenMeetingInformation;
import com.microsoft.graph.models.DeviceConfiguration;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows10Team General Configuration.
 */
public class Windows10TeamGeneralConfiguration extends DeviceConfiguration implements IJsonBackedObject {


    /**
     * The Azure Operational Insights Block Telemetry.
     * Indicates whether or not to Block Azure Operational Insights.
     */
    @SerializedName(value = "azureOperationalInsightsBlockTelemetry", alternate = {"AzureOperationalInsightsBlockTelemetry"})
    @Expose
	@Nullable
    public Boolean azureOperationalInsightsBlockTelemetry;

    /**
     * The Azure Operational Insights Workspace Id.
     * The Azure Operational Insights workspace id.
     */
    @SerializedName(value = "azureOperationalInsightsWorkspaceId", alternate = {"AzureOperationalInsightsWorkspaceId"})
    @Expose
	@Nullable
    public String azureOperationalInsightsWorkspaceId;

    /**
     * The Azure Operational Insights Workspace Key.
     * The Azure Operational Insights Workspace key.
     */
    @SerializedName(value = "azureOperationalInsightsWorkspaceKey", alternate = {"AzureOperationalInsightsWorkspaceKey"})
    @Expose
	@Nullable
    public String azureOperationalInsightsWorkspaceKey;

    /**
     * The Connect App Block Auto Launch.
     * Specifies whether to automatically launch the Connect app whenever a projection is initiated.
     */
    @SerializedName(value = "connectAppBlockAutoLaunch", alternate = {"ConnectAppBlockAutoLaunch"})
    @Expose
	@Nullable
    public Boolean connectAppBlockAutoLaunch;

    /**
     * The Maintenance Window Blocked.
     * Indicates whether or not to Block setting a maintenance window for device updates.
     */
    @SerializedName(value = "maintenanceWindowBlocked", alternate = {"MaintenanceWindowBlocked"})
    @Expose
	@Nullable
    public Boolean maintenanceWindowBlocked;

    /**
     * The Maintenance Window Duration In Hours.
     * Maintenance window duration for device updates. Valid values 0 to 5
     */
    @SerializedName(value = "maintenanceWindowDurationInHours", alternate = {"MaintenanceWindowDurationInHours"})
    @Expose
	@Nullable
    public Integer maintenanceWindowDurationInHours;

    /**
     * The Maintenance Window Start Time.
     * Maintenance window start time for device updates.
     */
    @SerializedName(value = "maintenanceWindowStartTime", alternate = {"MaintenanceWindowStartTime"})
    @Expose
	@Nullable
    public com.microsoft.graph.core.TimeOfDay maintenanceWindowStartTime;

    /**
     * The Miracast Blocked.
     * Indicates whether or not to Block wireless projection.
     */
    @SerializedName(value = "miracastBlocked", alternate = {"MiracastBlocked"})
    @Expose
	@Nullable
    public Boolean miracastBlocked;

    /**
     * The Miracast Channel.
     * The channel. Possible values are: userDefined, one, two, three, four, five, six, seven, eight, nine, ten, eleven, thirtySix, forty, fortyFour, fortyEight, oneHundredFortyNine, oneHundredFiftyThree, oneHundredFiftySeven, oneHundredSixtyOne, oneHundredSixtyFive.
     */
    @SerializedName(value = "miracastChannel", alternate = {"MiracastChannel"})
    @Expose
	@Nullable
    public MiracastChannel miracastChannel;

    /**
     * The Miracast Require Pin.
     * Indicates whether or not to require a pin for wireless projection.
     */
    @SerializedName(value = "miracastRequirePin", alternate = {"MiracastRequirePin"})
    @Expose
	@Nullable
    public Boolean miracastRequirePin;

    /**
     * The Settings Block My Meetings And Files.
     * Specifies whether to disable the 'My meetings and files' feature in the Start menu, which shows the signed-in user's meetings and files from Office 365.
     */
    @SerializedName(value = "settingsBlockMyMeetingsAndFiles", alternate = {"SettingsBlockMyMeetingsAndFiles"})
    @Expose
	@Nullable
    public Boolean settingsBlockMyMeetingsAndFiles;

    /**
     * The Settings Block Session Resume.
     * Specifies whether to allow the ability to resume a session when the session times out.
     */
    @SerializedName(value = "settingsBlockSessionResume", alternate = {"SettingsBlockSessionResume"})
    @Expose
	@Nullable
    public Boolean settingsBlockSessionResume;

    /**
     * The Settings Block Signin Suggestions.
     * Specifies whether to disable auto-populating of the sign-in dialog with invitees from scheduled meetings.
     */
    @SerializedName(value = "settingsBlockSigninSuggestions", alternate = {"SettingsBlockSigninSuggestions"})
    @Expose
	@Nullable
    public Boolean settingsBlockSigninSuggestions;

    /**
     * The Settings Default Volume.
     * Specifies the default volume value for a new session. Permitted values are 0-100. The default is 45. Valid values 0 to 100
     */
    @SerializedName(value = "settingsDefaultVolume", alternate = {"SettingsDefaultVolume"})
    @Expose
	@Nullable
    public Integer settingsDefaultVolume;

    /**
     * The Settings Screen Timeout In Minutes.
     * Specifies the number of minutes until the Hub screen turns off.
     */
    @SerializedName(value = "settingsScreenTimeoutInMinutes", alternate = {"SettingsScreenTimeoutInMinutes"})
    @Expose
	@Nullable
    public Integer settingsScreenTimeoutInMinutes;

    /**
     * The Settings Session Timeout In Minutes.
     * Specifies the number of minutes until the session times out.
     */
    @SerializedName(value = "settingsSessionTimeoutInMinutes", alternate = {"SettingsSessionTimeoutInMinutes"})
    @Expose
	@Nullable
    public Integer settingsSessionTimeoutInMinutes;

    /**
     * The Settings Sleep Timeout In Minutes.
     * Specifies the number of minutes until the Hub enters sleep mode.
     */
    @SerializedName(value = "settingsSleepTimeoutInMinutes", alternate = {"SettingsSleepTimeoutInMinutes"})
    @Expose
	@Nullable
    public Integer settingsSleepTimeoutInMinutes;

    /**
     * The Welcome Screen Background Image Url.
     * The welcome screen background image URL. The URL must use the HTTPS protocol and return a PNG image.
     */
    @SerializedName(value = "welcomeScreenBackgroundImageUrl", alternate = {"WelcomeScreenBackgroundImageUrl"})
    @Expose
	@Nullable
    public String welcomeScreenBackgroundImageUrl;

    /**
     * The Welcome Screen Block Automatic Wake Up.
     * Indicates whether or not to Block the welcome screen from waking up automatically when someone enters the room.
     */
    @SerializedName(value = "welcomeScreenBlockAutomaticWakeUp", alternate = {"WelcomeScreenBlockAutomaticWakeUp"})
    @Expose
	@Nullable
    public Boolean welcomeScreenBlockAutomaticWakeUp;

    /**
     * The Welcome Screen Meeting Information.
     * The welcome screen meeting information shown. Possible values are: userDefined, showOrganizerAndTimeOnly, showOrganizerAndTimeAndSubject.
     */
    @SerializedName(value = "welcomeScreenMeetingInformation", alternate = {"WelcomeScreenMeetingInformation"})
    @Expose
	@Nullable
    public WelcomeScreenMeetingInformation welcomeScreenMeetingInformation;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
