// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Rand Between Parameter Set.
 */
public class WorkbookFunctionsRandBetweenParameterSet {
    /**
     * The bottom.
     * 
     */
    @SerializedName(value = "bottom", alternate = {"Bottom"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement bottom;

    /**
     * The top.
     * 
     */
    @SerializedName(value = "top", alternate = {"Top"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement top;


    /**
     * Instiaciates a new WorkbookFunctionsRandBetweenParameterSet
     */
    public WorkbookFunctionsRandBetweenParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsRandBetweenParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsRandBetweenParameterSet(@Nonnull final WorkbookFunctionsRandBetweenParameterSetBuilder builder) {
        this.bottom = builder.bottom;
        this.top = builder.top;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsRandBetweenParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsRandBetweenParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsRandBetweenParameterSet
     */
    public static final class WorkbookFunctionsRandBetweenParameterSetBuilder {
        /**
         * The bottom parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement bottom;
        /**
         * Sets the Bottom
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsRandBetweenParameterSetBuilder withBottom(@Nullable final com.google.gson.JsonElement val) {
            this.bottom = val;
            return this;
        }
        /**
         * The top parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement top;
        /**
         * Sets the Top
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsRandBetweenParameterSetBuilder withTop(@Nullable final com.google.gson.JsonElement val) {
            this.top = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsRandBetweenParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsRandBetweenParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsRandBetweenParameterSet build() {
            return new WorkbookFunctionsRandBetweenParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.bottom != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("bottom", bottom));
        }
        if(this.top != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("top", top));
        }
        return result;
    }
}
